function NavMapAPI(navEngine)
{
	this._winRef = window;
	this.navEngine = navEngine;
}
NavMapAPI.prototype.createMapNode = NavMapAPICreateMapNode;
NavMapAPI.prototype.getChildren = NavMapAPIGetChildren;
NavMapAPI.prototype.getChildrenRec = NavMapAPIGetChildrenRec;
NavMapAPI.prototype.getLessonDescription = NavMapAPIGetLessonDescription;
NavMapAPI.prototype.getLessonTitle = NavMapAPIGetLessonTitle;
NavMapAPI.prototype.getMainRootId = NavMapAPIGetMainRootId;
NavMapAPI.prototype.getParentId = NavMapAPIGetParentId;
NavMapAPI.prototype.getRootId = NavMapAPIGetRootId;
NavMapAPI.prototype.getRootToNode = NavMapAPIGetRootToNode;
NavMapAPI.prototype.getRootToNodeRec = NavMapAPIGetRootToNodeRec;
NavMapAPI.prototype.getSiblings = NavMapAPIGetSiblings;
NavMapAPI.prototype.getSubtree = NavMapAPIGetSubtree;
NavMapAPI.prototype.getSubtreeRec = NavMapAPIGetSubtreeRec;
NavMapAPI.prototype.resolveNodeRef = NavMapAPIResolveNodeRef;

function NavMapAPIGetLessonTitle()
{
	return this.navEngine.title;
}

function NavMapAPIGetLessonDescription()
{
	return this.navEngine.description;
}

function NavMapAPIGetRootToNode(id)
{
	var nodeRef = this.resolveNodeRef(id);
	
	if (nodeRef != null)
	{
		var retVal = this.getRootToNodeRec(nodeRef);
		var child = retVal;
		while (retVal.parent != null)
		{
			retVal.parent.children[retVal.parent.children.length] = child;
			child = retVal.parent;
			retVal = retVal.parent;
		}
		return retVal;
	}
	else
	{
		return null;
	}
}

function NavMapAPIGetRootToNodeRec(nodeRef)
{
	if (!nodeRef.transparent || this.navEngine.isRootNode(nodeRef))
	{
		var mapNodeRef = new NavMapNode(nodeRef, this.navEngine);
		if (!this.navEngine.isRootNode(nodeRef))
		{
			mapNodeRef.parent = this.getRootToNodeRec(nodeRef.parentStack[0]);
		}
		return mapNodeRef;
	}
	else if (nodeRef.transparent && !this.navEngine.isRootNode(nodeRef))
	{
		return this.getRootToNodeRec(nodeRef.parentStack[0]);
	}
}

function NavMapAPIGetSubtree(id)
{
	var nodeRef = this.resolveNodeRef(id);
	
	if (nodeRef != null)
	{
		var root = new NavMapNode(nodeRef, this.navEngine);
		this.getSubtreeRec(root, nodeRef);
		return root;
	}
	else
	{
		return null;
	}
}

function NavMapAPIGetSubtreeRec(mapNode, navNode)
{
	var childArray = navNode.children;
	if (navNode.selectedChildren.length > 0)
	{
		childArray = navNode.selectedChildren;
	}
	for (var i=0;i<childArray.length;i++)
	{
		if (childArray[i].visible)
		{
			mapNode.children[mapNode.children.length] = new NavMapNode(childArray[i], this.navEngine);
			this.getSubtreeRec(mapNode.children[mapNode.children.length-1], childArray[i]);
		}
	}
}

function NavMapAPIGetSiblings(id, contentOnly)
{
	var nodeRef = this.resolveNodeRef(id);
		
	if (nodeRef != null)
	{
		var parentId = this.getParentId(nodeRef);
		while (parentId != null && this.navEngine.getNodeById(parentId).transparent)
		{
			parentId = this.getParentId(parentId);
		}
		if (parentId != null)
		{
			return this.getChildren(parentId, contentOnly);
		}
	}
	return null;
}

// Returns a NavMapNode representing the parent specified by
// the id parameter.  The returned NavMapNode contains, in its
// children[] array, one level of children only (the children do
// not contain their children recursively).
function NavMapAPIGetChildren(id, contentOnly)
{
	var nodeRef = this.resolveNodeRef(id);
	
	if (nodeRef != null)
	{
		var retVal = new NavMapNode(nodeRef, this.navEngine);
		var childArray = nodeRef.children;
		if (nodeRef.selectedChildren.length > 0)
		{
			childArray = nodeRef.selectedChildren;
		}
		for (var i=0;i<childArray.length;i++)
		{
			this.getChildrenRec(childArray[i], retVal, contentOnly);
		}
		return retVal;
	}
	else
	{
		return null;
	}
}

function NavMapAPIGetChildrenRec(childNodeRef, mapNodeParentRef, contentOnly)
{
	if (childNodeRef.visible)
	{
		if (childNodeRef.transparent || (contentOnly && childNodeRef.getUrl() == ""))
		{
			var childArray = childNodeRef.children;
			if (childNodeRef.selectedChildren.length > 0)
			{
				childArray = childNodeRef.selectedChildren;
			}
			for (var i=0;i<childArray.length;i++)
			{
				this.getChildrenRec(childArray[i], mapNodeParentRef, contentOnly);
			}
		}
		else
		{
			var navMapNode = new NavMapNode(childNodeRef, this.navEngine);
			navMapNode.parent = mapNodeParentRef;
			mapNodeParentRef.children[mapNodeParentRef.children.length] = navMapNode;
		}
	}
}

function NavMapAPIGetParentId(id)
{
	var nodeRef = this.resolveNodeRef(id);
		
	if (nodeRef != null)
	{
		var nextNode = nodeRef;
		while (nextNode != null)
		{
			if (nextNode.parentStack.length > 0 && !this.navEngine.isRootNode(nextNode))
			{
				nextNode = nextNode.parentStack[0];
				if (!nextNode.transparent)
				{
					return nextNode.id;
				}
			}
			else
			{
				if (nextNode != nodeRef)
				{
					return nextNode.id;
				}
				else
				{
					return null;
				}
			}
		}
	}
	else
	{
		return null;
	}
}

function NavMapAPIGetRootId(id)
{
	var nodeRef = this.resolveNodeRef(id);
		
	if (nodeRef != null)
	{
		while (!this.navEngine.isRootNode(nodeRef))
		{
			nodeRef = nodeRef.parentStack[0];
		}
		return nodeRef;
	}
	else
	{
		return null;
	}
}

function NavMapAPIGetMainRootId()
{
	return this.navEngine.forest[0].id;
}

function NavMapAPIResolveNodeRef(id)
{
	var nodeRef = null;	
	if (typeof(id) == "string")
	{	
		nodeRef = this.navEngine.getNodeById(id);
	}
	else
	{
		if (typeof(id) == "object" && id.constructor == NavNode)
		{
			nodeRef = id;
		}
		else
		{
			if (id == null)
			{
				nodeRef = this.navEngine.getCurrentNode();
			}
		}
	}
	
	return nodeRef;
}

function NavMapAPICreateMapNode(id)
{
	var nodeRef = this.resolveNodeRef(id);
	
	if (nodeRef != null)
	{
		return new NavMapNode(nodeRef, this.navEngine);
	}
	else
	{
		return null;
	}
}